var Login = new Class({
	owner: null,
  scr: null,
  el: null,
  
  initialize: function(o){
		this.owner = o;
    this.scr = new Template("login");
    this.el = new Element('div').adopt(this.scr.xml).getFirst();
		this.addFormEvents();
		
		var saved_login = this.loadLoginInfo();
		if($defined(saved_login) && saved_login){
			this.doLogin(saved_login.login, saved_login.pass);
		}
  },
	
	saveLoginInfo: function(login, pass){	
		var bytes = new air.ByteArray(); 
		bytes.writeUTFBytes(login);
		air.EncryptedLocalStore.setItem("login", bytes); 
		
    var bytes = new air.ByteArray(); 
    bytes.writeUTFBytes(pass);
    air.EncryptedLocalStore.setItem("pass", bytes);
	},
	
	loadLoginInfo: function(){
		stored_login = air.EncryptedLocalStore.getItem("login");
		stored_pass = air.EncryptedLocalStore.getItem("pass");
		if($defined(stored_login) && $defined(stored_pass)){
			return {'login': stored_login.readUTFBytes(stored_login.length), 'pass': stored_pass.readUTFBytes(stored_pass.length)};
		} else {
			return false;
		}
	},
	
	// registers event listeners
	addFormEvents: function(){
		var t = this;
		this.el.getElement("form").addEvent('submit', function(e){
      e.stop();
			t.submit(this);
		});
		
		this.el.getElement('a[id=register]').addEvent('click', function(e){
			e.stop();
			t.fireEvent('SectionChange', 'registration');
		});
		
		this.el.getElement('a[id=unregistered]').addEvent('click', function(e){
			e.stop();
			t.unregisteredLogin();
		});
    return this;
	},
	
	doLogin: function(login, pass, onSuccess, onFailure, onError){
    var tmp = this;	
    
    // do login request on server
    this.owner.server.request({'action': 'login', 'args': {'login': login, 'pass': pass}}, function(response){
      
      // wrong response
      if(!$defined(response)){
        if($defined(onError)){
					onFailure(response);
				} else {
          alert('Nepodarilo sa pripojiť - skúste to prosím neskôr.');
				}
        return;
    
      // login failed
      } else if($defined(response.error)) {
				if($defined(onFailure)) onFailure(response);
        
      // login was successful
      } else if($defined(response.user) && $defined(response.contacts)){
				if($defined(onSuccess)){
					onSuccess(response);
				} else {
	        tmp.owner.user = new User(tmp.owner, response.user);
	        tmp.owner.user.loadContacts(response.contacts);
	        tmp.fireEvent('SectionChange', 'main');
        }
      } else {
				alert('Vyskytla sa neznáma chyba.');
			}
    });
	},
	
	unregisteredLogin: function(){
		var t = this;
		
    // get new anonymous user
    this.owner.server.request({'action': 'registration_anonymous', 'args': {}}, function(response){
			
      // wrong response
      if(!$defined(response)){
        alert('Nepodarilo sa vytvoriť anonymného používateľa - skúste to prosím znovu.');
        return;
				
      // login was successful
      } else if($defined(response.login) && $defined(response.pass)){
				t.saveLoginInfo(response.login, response.pass);
				t.doLogin(response.login, response.pass);
      }
		});      
	},
	
	// submits login form
	submit: function(form){
    // assign elements 
    var loginel = this.el.getElement('input[name=login]');
    var passel = this.el.getElement('input[name=password]');
    var submitel = this.el.getElement('input[type=submit]');
    
    // check fields
    if(loginel.value.length == 0){
      alert('Zadajte prosím používateľské meno');
      return false;
    }
    
    if(passel.value.length == 0){
      alert('Zadajte prosím heslo');
      return false;
    }

    var login = SHA256(loginel.value);
    var pass = SHA256(passel.value);
		var t = this;
		
		var onFailure = function(){
      passel.value = '';
      loginel.value = '';
		}
		
		
		var onSuccess = function(response){
			if (t.el.getElement('input[name=autologin]').checked) {
		  	t.saveLoginInfo(login, pass);
		  }
      t.owner.user = new User(t.owner, response.user);
      t.owner.user.loadContacts(response.contacts);
      t.fireEvent('SectionChange', 'main');
		}
		
		this.doLogin(login, pass, onSuccess, onFailure, null);
		
    return this;
	},
			
	getEl: function(){
		return this.el;
	}
});

Login.implement(new Events);